/* FILE: atlerrs.h                              (D. Tottingham  01/26/91)

 Global error definitions. these error codes are returned from ATLAB
 subroutines.

*/

#define ALE_BUFFER      10      /* buffer over/underrun during I/O */
#define ALE_DAERR       9       /* D/A error detected */
#define ALE_ADERR       8       /* A/D error detected */
#define ALE_OUTTMO      7       /* user timeout exceeded on output */
#define ALE_INPTMO      6       /* user timeout exceeded on input */

#define ALE_NORMAL      0       /* success! */

#define ALE_NOATL       -1      /* device driver ATL not found */
#define ALE_MANYFIL     -2      /* too many files open */
#define ALE_DMAASN      -7      /* DMA channel not assigned to unit */
#define ALE_GAIN        -10     /* illegal gain specification */
#define ALE_DMABND      -13     /* DMA buffer crosses 64K boundary */
#define ALE_NVALUE      -16     /* non-positive number of values argument */
#define ALE_TIMING      -19     /* illegal timing source value */
#define ALE_HIFREQ      -22     /* requested frequency too high */
#define ALE_LOFREQ      -23     /* requested frequency too low */
#define ALE_SMALLP      -24     /* requested period too small */
#define ALE_LARGEP      -25     /* requested period too large */
#define ALE_PORT        -27     /* illegal digital port */
#define ALE_CHANNL      -29     /* illegal channel number */
#define ALE_BOARD       -31     /* illegal board number */
#define ALE_NOBCB       -50     /* no Buffer Control Blocks available */
#define ALE_NOXMS       -51     /* no extended memory buffer available */
#define ALE_ODDALIGN    -52     /* buffer aligned on an odd-byte boundary */
#define ALE_NOTBUFF     -53     /* invalid buffer number */
#define ALE_BADLEN      -54     /* illegal buffer length */
#define ALE_CPYBUF      -55     /* illegal transfer count during copy buffer */
#define ALE_IOINPROG    -56     /* I/O in progress using buffers */
#define ALE_LINKED      -57     /* buffer already linked */
#define ALE_NOUNDCL     -58     /* buffer is linked to Buffer Transfer List */
#define ALE_RELEASED    -59     /* buffer already released to user */
#define ALE_NOTLINK     -60     /* buffer not linked to Buffer Transfer List */
#define ALE_RETURNED    -61     /* buffer already returned */
#define ALE_NOFILE      -62     /* no file by that name exists */
#define ALE_NOOPEN      -63     /* can't open the requested file */
#define ALE_FREAD       -64     /* error reading data file */
#define ALE_FWRITE      -65     /* error writing data file */
#define ALE_NOTDAT      -66     /* not an ATLAB data file */
#define ALE_EOF         -67     /* end of file encountered on data file */
#define ALE_NOTINPROG   -68     /* I/O not in progress */
#define ALE_BADBTL      -69     /* illegal Buffer Transfer List */

#define ALE_NODASUPP    -70     /* no D/A conversion on this board */
#define ALE_SCANLIST    -71     /* board cannot perform single channel A/D  */

#define ALE_BANKSWITCH  -72     /* erratic bank switch encountered on mux */

#define ALE_UNEXP       -100    /* unexpected error */

/*  end ATLERRS.H */
